/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.createtweaker.managers;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.action.recipe.ActionRecipeBase;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.createtweaker.managers.base.IProcessingRecipeManager;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.contraptions.processing.EmptyingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.create.EmptyingManager")
@Document(value="mods/createtweaker/EmptyingManager")
public class EmptyingManager
implements IProcessingRecipeManager<EmptyingRecipe> {
    @ZenCodeType.Method
    public void addRecipe(String name, Percentaged<IItemStack> outputItem, IFluidStack outputFluid, IIngredient inputContainer, @ZenCodeType.OptionalInt(value=100) int duration) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        ProcessingRecipeBuilder builder = new ProcessingRecipeBuilder(this.getSerializer().getFactory(), resourceLocation);
        builder.output((float)outputItem.getPercentage(), ((IItemStack)outputItem.getData()).getInternal());
        builder.output(outputFluid.getInternal());
        builder.require(inputContainer.asVanillaIngredient());
        builder.duration(duration);
        EmptyingRecipe recipe = (EmptyingRecipe)builder.build();
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (Recipe)recipe));
    }

    @ZenCodeType.Method
    public void remove(final IFluidStack output) {
        CraftTweakerAPI.apply((IAction)new ActionRecipeBase<EmptyingRecipe>((IRecipeManager)this){

            public void apply() {
                ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
                for (ResourceLocation location : this.getManager().getRecipes().keySet()) {
                    EmptyingRecipe recipe = (EmptyingRecipe)this.getManager().getRecipes().get(location);
                    if (recipe.getFluidResults().isEmpty() || !output.getInternal().isFluidEqual(recipe.getResultingFluid())) continue;
                    toRemove.add(location);
                }
                toRemove.forEach(this.getManager().getRecipes()::remove);
            }

            public String describe() {
                return "Removing \"" + Registry.f_122864_.m_7981_((Object)this.getManager().getRecipeType()) + "\" recipes with output: " + output + "\"";
            }
        });
    }

    @Override
    public AllRecipeTypes getCreateRecipeType() {
        return AllRecipeTypes.EMPTYING;
    }
}

